#include <yandex/maps/wiki/configs/editor/interactivity.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class Interactivity::Impl
{
public:
    explicit Impl(const maps::xml3::Node& node)
        : hotspotSimplificationTolerance_(1)
        , hotspotWidth_(5.0)
        , geometrySimplificationTolerance_(node.attr<unsigned int>("simplification-tolerance", 0))
        , simplificationMinNumberPoints_(node.attr<unsigned int>("simplification-min-number-points", 0))
        , hotspotZOrder_(0)
    {
        auto hotspotNode = node.node("hotspot", true);
        if (!hotspotNode.isNull()) {
            hotspotSimplificationTolerance_ = hotspotNode.attr<unsigned int>("simplification-tolerance");
            hotspotWidth_ = hotspotNode.attr<double>("width");
            hotspotZOrder_ = hotspotNode.attr<TZOrder>("zorder");
        }
    }

    unsigned int hotspotSimplificationTolerance_;
    double hotspotWidth_;
    unsigned int geometrySimplificationTolerance_;
    unsigned int simplificationMinNumberPoints_;
    TZOrder hotspotZOrder_;
};

MOVABLE_PIMPL_DEFINITIONS(Interactivity)

Interactivity::Interactivity(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

unsigned int Interactivity::hotspotSimplificationTolerance() const
{ return impl_->hotspotSimplificationTolerance_; }

double Interactivity::hotspotWidth() const
{ return impl_->hotspotWidth_; }

unsigned int Interactivity::geometrySimplificationTolerance() const
{ return impl_->geometrySimplificationTolerance_; }

unsigned int Interactivity::simplificationMinNumberPoints() const
{ return impl_->simplificationMinNumberPoints_; }

TZOrder Interactivity::hotspotZOrder() const
{ return impl_->hotspotZOrder_; }

} // editor
} // configs
} // wiki
} // maps
