#include <yandex/maps/wiki/configs/editor/master_role.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class MasterRole::Impl
{
public:
    Impl(
            std::string roleId,
            std::string categoryId,
            size_t minOccurs,
            std::optional<size_t> maxOccurs)
        : roleId_(std::move(roleId))
        , categoryId_(std::move(categoryId))
        , minOccurs_(minOccurs)
        , maxOccurs_(maxOccurs)
    {
    }

    std::string roleId_;
    std::string categoryId_;
    size_t minOccurs_;
    std::optional<size_t> maxOccurs_;
};

COPYABLE_PIMPL_DEFINITIONS(MasterRole)

MasterRole::MasterRole(
        std::string roleId,
        std::string categoryId,
        size_t minOccurs,
        std::optional<size_t> maxOccurs)
    : impl_(new Impl{
        std::move(roleId),
        std::move(categoryId),
        minOccurs,
        maxOccurs})
{}

const std::string& MasterRole::roleId() const { return impl_->roleId_; }
const std::string& MasterRole::categoryId() const { return impl_->categoryId_; }
size_t MasterRole::minOccurs() const { return impl_->minOccurs_; }
std::optional<size_t> MasterRole::maxOccurs() const { return impl_->maxOccurs_; }

bool MasterRole::isRestricted() const
{
    return ((impl_->minOccurs_ > 0) || impl_->maxOccurs_);
}

} // editor
} // configs
} // wiki
} // maps
