#include <yandex/maps/wiki/configs/editor/restrictions.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class Gabarits::Impl
{
public:
    explicit Impl(const maps::xml3::Node& node)
    {
        auto maxSizeNode = node.node("max-size", true);
        if (!maxSizeNode.isNull()) {
            maxSize = Size(maxSizeNode);
        }

        auto minSizeNode = node.node("min-size", true);
        if (!minSizeNode.isNull()) {
            minSize = Size(minSizeNode);
        }

        if (!maxSize && !minSize) {
            auto lengthNode = node.node("length", false);
            length = lengthNode.attr<double>("value");
            lengthAccuracy = lengthNode.attr<double>("accuracy");
        }
    }

    std::optional<double> length;
    std::optional<double> lengthAccuracy;
    std::optional<Size> maxSize;
    std::optional<Size> minSize;
};

COPYABLE_PIMPL_DEFINITIONS(Gabarits)

Gabarits::Gabarits(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

std::optional<Size> Gabarits::maxSize() const { return impl_->maxSize; }
std::optional<Size> Gabarits::minSize() const { return impl_->minSize; }
std::optional<double> Gabarits::length() const { return impl_->length; }
std::optional<double> Gabarits::lengthAccuracy() const { return impl_->lengthAccuracy; }

//================================================================

class Restrictions::Impl
{
public:
    explicit Impl(const maps::xml3::Node& node)
        : maxIntersectionWithElement(5)
        , maxCrossedElements(5)
        , maxVertexes(0)
        , maxRichContentLength(0)
    {
        auto maxVertNode = node.node("strong/max-vertexes");
        maxVertexes = maxVertNode.value<size_t>(100);

        auto maxRichContentLengthNode = node.node("strong/max-rich-content-length");
        maxRichContentLength = maxRichContentLengthNode.value<size_t>();

        auto gabaritsNode = node.node("strong/gabarits", true);
        if (!gabaritsNode.isNull()) {
            gabarits = Gabarits(gabaritsNode);
        }

        auto nodeMaxIntersectionWithElement = node.node("strong/max-intersection-with-element", true);
        if (!nodeMaxIntersectionWithElement.isNull()) {
            maxIntersectionWithElement = nodeMaxIntersectionWithElement.value<size_t>();
        }

        auto nodeMaxCrossedElements = node.node("strong/max-crossed-elements", true);
        if (!nodeMaxCrossedElements.isNull()) {
            maxCrossedElements = nodeMaxCrossedElements.value<size_t>();
        }
    }

    size_t maxIntersectionWithElement;
    size_t maxCrossedElements;
    size_t maxVertexes;
    size_t maxRichContentLength;
    std::optional<Gabarits> gabarits;
};

MOVABLE_PIMPL_DEFINITIONS(Restrictions)

Restrictions::Restrictions(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

size_t Restrictions::maxIntersectionWithElement() const { return impl_->maxIntersectionWithElement; }
size_t Restrictions::maxCrossedElements() const { return impl_->maxCrossedElements; }
size_t Restrictions::maxVertexes() const { return impl_->maxVertexes; }
size_t Restrictions::maxRichContentLength() const { return impl_->maxRichContentLength; }
const std::optional<Gabarits>& Restrictions::gabarits() const { return impl_->gabarits; }

} // editor
} // configs
} // wiki
} // maps

