#include <yandex/maps/wiki/configs/editor/section.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class Section::Impl
{
public:
    explicit Impl(const maps::xml3::Node& node)
        : id(node.attr<std::string>("id"))
    {
        auto attributeRefs = node.nodes("attribute");
        for (size_t i = 0; i < attributeRefs.size(); ++i) {
            attributes.push_back(attributeRefs[i].attr<std::string>("id"));
        }
    }

    std::string id;
    StringVec attributes;
};

MOVABLE_PIMPL_DEFINITIONS(Section)

Section::Section(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

const std::string& Section::id() const { return impl_->id; }
const StringVec& Section::attributes() const { return impl_->attributes; }

} // editor
} // configs
} // wiki
} // maps
