#include <yandex/maps/wiki/configs/editor/size.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class Size::Impl
{
public:
    Impl(double width, double height)
        : width(width)
        , height(height)
    {}

    explicit Impl(const maps::xml3::Node& node)
        : width(node.attr<double>("width"))
        , height(node.attr<double>("height"))
    {}

    double width;
    double height;
};

COPYABLE_PIMPL_DEFINITIONS(Size)

Size::Size(double width, double height)
    : impl_(new Impl{width, height})
{}

Size::Size(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

double Size::width() const { return impl_->width; }
double Size::height() const { return impl_->height; }

bool Size::greater(const Size& other) const
{
    return (std::min(impl_->height, impl_->width) > std::min(other.impl_->height, other.impl_->width))
        && (std::max(impl_->height, impl_->width) > std::max(other.impl_->height, other.impl_->width));
}

bool Size::less(const Size& other) const
{
    return other.greater(*this);
}

} // editor
} // configs
} // wiki
} // maps
