#include <yandex/maps/wiki/configs/editor/slave_role.h>
#include <yandex/maps/wiki/configs/editor/magic_strings.h>

#include <boost/lexical_cast.hpp>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

namespace {
const std::string UNBOUNDED = "unbounded";
} // namespace

class SlaveRole::Impl
{
public:
    explicit Impl(const maps::xml3::Node& node)
        : roleId_(node.attr<std::string>("id"))
        , categoryId_(node.attr<std::string>("category-id"))
        , minOccurs_(node.attr<size_t>("min-occurs"))
        , maxOccurs_(node.attr<size_t>("max-occurs"))
        , allowDelete_(node.attr<bool>("allow-delete"))
        , allowReplace_(node.attr<bool>("allow-replace"))
        , keepAll_(node.attr<bool>("keep-all"))
        , inheritLabels_(node.attr<bool>("inherit-labels", false))
        , tableRow_(node.attr<bool>("table-row", false))
        , sequential_(node.attr<bool>("sequential", false))
        , geomPart_(node.attr<bool>("geom-part", false))
        , allowSelfReference_(node.attr<bool>("allow-self-reference", false))
        , deleteUnused_(node.attr<bool>("delete-unused", false))
        , masterMinOccurs_(node.attr<size_t>("master-min-occurs"))
        , limitSlaveEditNotes_(node.attr<bool>("limit-slave-edit-notes", false))
        , nonBlocking_(node.attr<bool>("non-blocking", false))
    {
        auto masterMaxOccurs = node.attr<std::string>("master-max-occurs");
        if (masterMaxOccurs != UNBOUNDED) {
            masterMaxOccurs_ = boost::lexical_cast<size_t>(masterMaxOccurs);
        }
        auto slavesPerRoleOutputLimitNodeAttr = node.attr<std::string>("slaves-per-role-output-limit", "");
        if (!slavesPerRoleOutputLimitNodeAttr.empty()) {
            slavesPerRoleOutputLimit_ = boost::lexical_cast<size_t>(slavesPerRoleOutputLimitNodeAttr);
        }
    }

    std::string roleId_;
    std::string categoryId_;
    size_t minOccurs_;
    size_t maxOccurs_;

    bool allowDelete_;
    bool allowReplace_;
    bool keepAll_;
    bool inheritLabels_;
    bool tableRow_;
    bool sequential_;
    bool geomPart_;
    bool allowSelfReference_;
    bool deleteUnused_;

    size_t masterMinOccurs_;
    std::optional<size_t> masterMaxOccurs_;
    bool limitSlaveEditNotes_;
    bool nonBlocking_;
    std::optional<size_t> slavesPerRoleOutputLimit_;
};

MOVABLE_PIMPL_DEFINITIONS(SlaveRole)

SlaveRole::SlaveRole(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

const std::string& SlaveRole::roleId() const { return impl_->roleId_; }
const std::string& SlaveRole::categoryId() const { return impl_->categoryId_; }
size_t SlaveRole::minOccurs() const { return impl_->minOccurs_; }
size_t SlaveRole::maxOccurs() const { return impl_->maxOccurs_; }
size_t SlaveRole::masterMinOccurs() const { return impl_->masterMinOccurs_; }
std::optional<size_t> SlaveRole::masterMaxOccurs() const { return impl_->masterMaxOccurs_; }
bool SlaveRole::allowDelete() const { return impl_->allowDelete_; }
bool SlaveRole::allowReplace() const { return impl_->allowReplace_; }
bool SlaveRole::keepAll() const { return impl_->keepAll_; }
bool SlaveRole::inheritLabels() const { return impl_->inheritLabels_; }
bool SlaveRole::tableRow() const { return impl_->tableRow_; }
bool SlaveRole::sequential() const { return impl_->sequential_; }
bool SlaveRole::geomPart() const { return impl_->geomPart_; }
bool SlaveRole::allowSelfReference() const { return impl_->allowSelfReference_; }
bool SlaveRole::deleteUnused() const { return impl_->deleteUnused_; }
bool SlaveRole::limitSlaveEditNotes() const { return impl_->limitSlaveEditNotes_; }
bool SlaveRole::nonBlocking() const { return impl_->nonBlocking_; }
std::optional<size_t> SlaveRole::slavesPerRoleOutputLimit() const { return impl_->slavesPerRoleOutputLimit_; }

SlaveRole::operator std::string() const { return impl_->roleId_; }

StringVec SlaveRole::nonSyncViewRoles()
{
    auto roles = NAME_TYPES_PRIORITY;
    roles.push_back(ROLE_START);
    roles.push_back(ROLE_END);
    return roles;
}

bool SlaveRole::isSyncViewRole(const std::string& role)
{
    if (role == ROLE_START || role == ROLE_END) {
        return false;
    }
    return std::find(NAME_TYPES_PRIORITY.begin(), NAME_TYPES_PRIORITY.end(), role)
            == NAME_TYPES_PRIORITY.end();
}

} // editor
} // configs
} // wiki
} // maps
