#!/usr/bin/python
# coding: utf-8

import argparse
from lxml import etree

parser = argparse.ArgumentParser()
parser.add_argument("--input", help="Path for the input file", required=True)
parser.add_argument("--output",  help="Path to the output file", required=True)
args = parser.parse_args()

tree = etree.parse(args.input)
tree.xinclude()

with open(args.output, 'w') as out:
    tree.write(out, pretty_print=True, encoding="utf-8", xml_declaration=True)
