#pragma once

#include <string>

namespace maps::wiki::controller {

struct AsyncTaskControlData
{
    std::string metadataJson;
    std::string recoveryPatternJson;
    std::string conflictPatternJson;
    std::string requestData;

    bool empty() const {
        return
            metadataJson.empty() &&
            recoveryPatternJson.empty() &&
            conflictPatternJson.empty();
    }
};

template <typename T>
concept HasAsyncTaskControlData = std::is_same_v<decltype(T::asyncTaskControlData(std::declval<typename T::Request>())), AsyncTaskControlData>;

template <typename T> requires HasAsyncTaskControlData<T>
AsyncTaskControlData asyncTaskControlData(const typename T::Request& request) {
    return T::asyncTaskControlData(request);
}

template <typename T> requires (!HasAsyncTaskControlData<T>)
AsyncTaskControlData asyncTaskControlData(const typename T::Request& request) {
    AsyncTaskControlData data;
    data.requestData = request.dump();
    return data;
}

} // namespace maps::wiki::controller
