#pragma once

#include <memory>

namespace maps {

namespace pgpool3 {

class Pool;

} // namespace pgpool3

namespace wiki {

namespace taskutils {
class TaskManager;
} // namespace taskutils

class ThreadPool;

namespace common {
class ExtendedXmlDoc;
} // namespace common

namespace controller {
struct AsyncTasksParams
{
    const size_t waitResponseTimeout;
    const size_t methodTimeout;
};

class AsyncTasksSupport
{
public:
    AsyncTasksSupport(
        pgpool3::Pool& poolCore,
        const common::ExtendedXmlDoc& doc,
        const std::string& configSectionPath);

    ~AsyncTasksSupport();

    const taskutils::TaskManager& manager() const;
    const AsyncTasksParams& params() const;
    ThreadPool& threadPool() const;
    pgpool3::Pool& corePool() const;
    void shutdown();
    void terminateTasks();

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};

} // namespace controller
} // namespace wiki
} // namespace maps
