#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/libs/controller/include/async_tasks_support.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/task.h>

namespace maps::wiki::controller {

class AsyncTaskContext;
class AsyncBaseController;
struct AsyncTaskControlData;

template<>
struct ResultType<AsyncBaseController>
{
    std::string taskName;
    std::string tokenStr;
    std::string result;

    std::string toJson() const;
};

class AsyncBaseController: public BaseController<AsyncBaseController>
{
public:
    enum class WaitPolicy
    {
        NoWait,
        Timeout
    };

    AsyncBaseController(
        const std::string& profileWhere,
        WaitPolicy waitPolicy,
        const AsyncTasksSupport& asyncTasksSupport);

    virtual const std::string& taskName() const = 0;

protected:
    typedef std::shared_ptr<AsyncTaskContext> AsyncTaskContextPtr;
    void execTaskContext(const AsyncTaskContextPtr& ctx);

    std::optional<taskutils::Task> createTask(
        taskutils::TUid uid,
        const AsyncTaskControlData& asyncTaskControlData);

private:
    WaitPolicy waitPolicy_ = WaitPolicy::Timeout;
    const AsyncTasksSupport& asyncTasksSupport_;
};

} // namespace maps::wiki::controller
