#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/asynctaskresult.h>
#include <maps/wikimap/mapspro/libs/controller/include/exception_info.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/task.h>

#include <memory>


namespace maps::wiki::controller {

class AsyncTasksSupport;

class AsyncTaskContext {
public:
    explicit AsyncTaskContext(taskutils::Task task);
    virtual ~AsyncTaskContext();

    class Result
    {
    public:
        Result() = default;

        bool empty() const { return data_.empty(); }
        std::string fetch();

    private:
        friend class AsyncTaskContext;
        Result(std::string data, IsInternalError isInternalError)
            : data_(std::move(data))
            , isInternalError_(isInternalError)
        {}

        std::string data_; // valid result or internal error what message
        IsInternalError isInternalError_ = IsInternalError::No;
    };

    Result run(const AsyncTasksSupport& asyncTasksSupport);

protected:

    virtual void createWorker() = 0;
    virtual std::string invokeWorker() = 0;
    virtual ExceptionInfo handleWorkerException() = 0;
    virtual std::string formatResult(const AsyncTaskResult&) const = 0;


    void start(const AsyncTasksSupport& asyncTasksSupport);
    taskutils::TaskResult finish(const std::string& result, const AsyncTasksSupport& asyncTasksSupport) const;
    taskutils::TaskResult fail(const std::string& err, const AsyncTasksSupport& asyncTasksSupport) const;

    const taskutils::Task& task() const { return task_; }


private:
    taskutils::Task task_;
};

} // namespace maps::wiki::controller
