#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/taskutils.h>

namespace maps::wiki::controller {

class AsyncTasksSupport;

class AsyncTaskResult
{
public:
    explicit AsyncTaskResult(const taskutils::Token& token);

    AsyncTaskResult(
        const taskutils::Token& token,
        const taskutils::TaskResult& taskResult);

    void load(const AsyncTasksSupport& asyncTasksSupport);
    void fail(const std::string& errorMsg);

    const taskutils::Token& token() const { return token_;}
    const taskutils::TaskStatus& status() const { return status_;}
    const std::string& result() const { return result_;}
    const std::string& error() const { return error_;}

    std::string toJson() const;

private:
    void parse(const taskutils::TaskResult& taskResult);

    taskutils::Token token_;
    taskutils::TaskStatus status_;
    std::string result_;
    std::string error_;
};

} // namespace maps::wiki::controller
