#pragma once

#include <string>

namespace maps::wiki::controller {

enum class IsInternalError { Yes, No };

class ExceptionInfo
{
public:
    ExceptionInfo() = default;

    ExceptionInfo(
            std::string what,
            std::string formattedMessage,
            IsInternalError isInternalError)
        : what_(std::move(what))
        , formattedMessage_(std::move(formattedMessage))
        , isInternalError_(isInternalError)
    {}

    const std::string& what() const { return what_; }
    const std::string& formattedMessage() const { return formattedMessage_; }
    IsInternalError isInternalError() const { return isInternalError_; }

private:
    std::string what_;
    std::string formattedMessage_;
    IsInternalError isInternalError_ = IsInternalError::No;
};

} // namespace maps::wiki::controller
