#pragma once

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/common/include/profiletimer.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>
#include <string>

namespace maps::wiki::controller {

class Profile
{
public:
    explicit Profile(const std::string& where);
    ~Profile();

    Profile() = delete;
    Profile(const Profile&) = delete;
    Profile(Profile&&) = delete;
    /**
    * Report successeful complition
    */
    void success(const std::string& message="")
    {
        level_ = maps::log8::Level::INFO;
        message_= message;
    }

    /**
    * Report erroneous complition
    */
    void error(const std::string& message="")
    {
        level_ = maps::log8::Level::ERROR;
        message_= message;
    }

    /**
    * Report warning
    */
    void warning(const std::string& message="")
    {
        level_ = maps::log8::Level::WARNING;
        message_= message;
    }

    /**
    * Get time from incapsulated timer
    */
    std::string elapsedTime();

    /**
    * Context/Name
    */
    const std::string& where()const
    { return where_;}

    void setCallDetails(
        const std::string& callDetails,
        taskutils::TaskID asyncTaskID)
    {
        callDetails_ = callDetails;
        asyncTaskID_ = asyncTaskID;
    }

    void logState();

    void setAsyncTaskID(taskutils::TaskID);

private:
    ProfileTimer timer_;
    maps::log8::Level level_;
    std::string where_;
    std::string message_;
    std::string callDetails_;
    taskutils::TaskID asyncTaskID_;
};

} // namespace maps::wiki::controller
