#include <maps/wikimap/mapspro/libs/controller/include/async_control_support.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::controller::tests {

struct NoSupport
{
    struct Request
    {
        std::string dump() const { return {}; }
    };
};

struct Support
{
    struct Request
    {
        std::string dump() const { return {}; }
    };
    static controller::AsyncTaskControlData asyncTaskControlData(const Request&)
    {
        return controller::AsyncTaskControlData {
            "1", "2", "3", "4"
        };
    }
};

struct SupportNonDefaultRequest
{
    struct Request
    {
        Request() = delete;
        Request(int b):a(b){}
        std::string dump() const { return {}; }
        int a;
    };
    static controller::AsyncTaskControlData asyncTaskControlData(const Request&)
    {
        return controller::AsyncTaskControlData {
            "1", "2", "3", "4"
        };
    }
};

Y_UNIT_TEST_SUITE(test_async_control_compile)
{
Y_UNIT_TEST(test_async_control_supported_not_def_construct_request)
{
    SupportNonDefaultRequest::Request r{100};
    UNIT_ASSERT(!asyncTaskControlData<SupportNonDefaultRequest>(r).empty());
}

Y_UNIT_TEST(test_async_control_supported)
{
    UNIT_ASSERT(!asyncTaskControlData<Support>(Support::Request()).empty());
}

Y_UNIT_TEST(test_async_control_not_supported)
{
    UNIT_ASSERT(asyncTaskControlData<NoSupport>(NoSupport::Request()).empty());
}
} // Y_UNIT_TEST_SUITE(test_async_control_compile)

} // namespace maps::wiki::controller::tests
