#pragma once

#include <map>
#include <string>
#include <vector>

namespace maps::wiki::dbutils {

/**
 * Parse csv string. Spaces and tabs ignored unless inside quotes
 * @param csvString - string to parse
 * @param delimiter - character to delimit phrases
 * @param escape - character used in csvString as shield
 * @return vector of individual phrases
 */
std::vector<std::string>
parseCSV(const std::string& csvString, char delimiter, char escape);

std::vector<std::string>
parsePGArray(const std::string& postgresArray);

std::map<std::string, std::string>
parsePGHstore(const std::string& hstoreArray);

} // namespace maps::wiki::dbutils
