#include "rd.h"
#include "magic_string.h"
#include "utils.h"
#include "../message_reporter.h"

#include <yandex/maps/wiki/diffalert/object.h>
#include <yandex/maps/wiki/common/rd/cond_type.h>

#include <string>

namespace maps {
namespace wiki {
namespace diffalert {
namespace {

const double MAX_ARRIVAL_POINT_DISPLACEMENT = 30.0; // meters

}
void checkArrivalPointModified(const DiffContext& diff, MessageReporter& messages)
{
    if (!(diff.categoryId() == cat::ARRIVAL_POINT)) {
        return;
    }

    if (!diff.oldObject()) {
        messages.report({2, 0}, "arrival-point-created");
        return;
    }

    if (!diff.newObject()) {
        messages.report({1, 0}, "arrival-point-deleted");
        return;
    }

    if (diff.attrsChanged() || diff.tableAttrsChanged()) {
        messages.report({2, 0}, "arrival-point-attributes-modified");
    }

    if (!diff.geomChanged()) {
        return;
    }

    const auto& oldGeom = diff.oldObject()->geom();
    const auto& newGeom = diff.newObject()->geom();
    const double distanceMeter = mercatorDistanceRatio(oldGeom) * oldGeom.distance(newGeom);
    if (distanceMeter > MAX_ARRIVAL_POINT_DISPLACEMENT) {
        messages.report({1, 0}, "arrival-point-big-displacement", Message::Scope::GeomDiff);
    }
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
