#pragma once

#include <set>
#include <string>

namespace maps::wiki::diffalert {

namespace role {
namespace name {

const std::string OFFICIAL = "official";
const std::string RENDER_LABEL = "render_label";
const std::string ADDRESS_LABEL = "address_label";
const std::string SHORT = "short";
const std::string SYNONYM = "synonym";
const std::string OLD = "old";

const std::set<std::string> ALL_ROLES {
    OFFICIAL,
    RENDER_LABEL,
    ADDRESS_LABEL,
    SHORT,
    SYNONYM,
    OLD
};

} // namespace name

const std::string APPLIED_TO = "applied_to";
const std::string ASSIGNED = "assigned";
const std::string ASSIGNED_THREAD = "assigned_thread";
const std::string ASSIGNED_THREAD_STOP = "assigned_thread_stop";
const std::string ASSOCIATED_WITH = "associated_with";
const std::string BLD_ASSIGNED = "bld_assigned";
const std::string BUS_PART = "bus_part";
const std::string CHILD = "child";
const std::string END = "end";
const std::string EXCLUSION = "exclusion";
const std::string FC_PART = "fc_part";
const std::string FLAT_RANGE_ASSIGNED = "flat_range_assigned";
const std::string FROM = "from";
const std::string METRO_PART = "metro_part";
const std::string PARKING_LOT_LINEAR_ASSIGNED = "parking_lot_linear_assigned";
const std::string PART = "part";
const std::string START = "start";
const std::string SUBSTITUTION = "substitution";
const std::string TO = "to";
const std::string TRAM_PART = "tram_part";
const std::string URBAN_AREAL_ASSIGNED = "urban_areal_assigned";
const std::string VIA = "via";
const std::string WATERWAY_PART = "waterway_part";

} // namespace role

namespace attr {

// name
const std::string NAME = "name";
const std::string LANG = "lang";
const std::string IS_LOCAL = "is_local";

// bld
const std::string HEIGHT = "height";
const std::string COND = "cond";

// ad
const std::string CAPITAL = "capital";
const std::string TOWN = "town";
const std::string LEVEL_KIND = "level_kind";
const std::string RECOGNITION = "recognition";
const std::string POPULATION = "population";
const std::string INFORMAL = "informal";
const std::string MUNICIPALITY = "municipality";

// rd
const std::string ACCESS_ID = "access_id";
const std::string TOLL = "toll";
const std::string SRV_UC = "srv_uc";
const std::string SRV_UC_OPEN_AT = "srv_uc_open_at";
const std::string SPEED_CAT = "speed_cat";
const std::string RD_TYPE = "rd_type";
const std::string FC = "fc";
const std::string CAT_BOUND_JC = "cat:bound_jc";
const std::string POOR_CONDITION = "poor_condition";
const std::string FOW = "fow";

// cond
const std::string COND_TYPE = "cond_type";

// common
const std::string DISP_CLASS = "disp_class";
const std::string FT_TYPE_ID = "ft_type_id";
const std::string IS_INTERIOR = "is_interior";
const std::string SYS_BLOCKED = "sys:blocked";

// masstransit
const std::string SYS_NOT_OPERATING = "sys:not_operating";
const std::string TRANSPORT_STOP_WAYPOINT = "transport_stop:waypoint";

// freq
const std::string FREQ_DT_DATE_START = "freq_dt:date_start";
const std::string FREQ_DT_DATE_END = "freq_dt:date_end";
const std::string FREQ_DT_TIME_START = "freq_dt:time_start";
const std::string FREQ_DT_TIME_END = "freq_dt:time_end";
const std::string FREQ_DT_DEPARTURE_TIME = "freq_dt:departure_time";
const std::string FREQ_DT_ALTERNATIVE = "freq_dt:alternative";
const std::string FREQ_DT_FREQ = "freq_dt:freq";
const std::string FREQ_DT_DAY= "freq_dt:day";

// parkings
const std::string URBAN_ROADNET_PARKING_LOT_BLD = "urban_roadnet_parking_lot:bld";

// poi
const std::string OPEN_TYPE = "open_type";
const std::string POI_IS_GEOPRODUCT = "poi:is_geoproduct";
const std::string POI_BUSINESS_ID = "poi:business_id";
const std::string POI_BUSINESS_RUBRIC_ID = "poi:business_rubric_id";
const std::string POI_POSITION_QUALITY = "poi:position_quality";
const std::string INDOOR_POI_POSITION_QUALITY = "indoor_poi:position_quality";

// flat range
const std::string FLAT_RANGE_FLATS = "flat_range:flats";
const std::string FLAT_RANGE_LEVELS = "flat_range:levels";

namespace value {

const std::string PRECISE = "precise";
const std::string APPROXIMATE = "approximate";

} // namespace value

} // namespace attr

namespace cat {

const std::string ADDR = "addr";
const std::string BLD = "bld";
const std::string COND = "cond";
const std::string COND_DS = "cond_ds";
const std::string COND_DS_EL = "cond_ds_el";
const std::string COND_TOLL = "cond_toll";
const std::string COND_ANNOTATION = "cond_annotation";

const std::string AD = "ad";
const std::string AD_SUBST = "ad_subst";

const std::string ARRIVAL_POINT = "arrival_point";

const std::string URBAN = "urban";
const std::string URBAN_AREAL = "urban_areal";

const std::string URBAN_ROADNET = "urban_roadnet";
const std::string URBAN_ROADNET_AREAL = "urban_roadnet_areal";
const std::string URBAN_ROADNET_PARKING_LOT = "urban_roadnet_parking_lot";
const std::string URBAN_ROADNET_PARKING_LOT_LINEAR = "urban_roadnet_parking_lot_linear";

const std::string RD = "rd";
const std::string RD_EL = "rd_el";
const std::string RD_JC = "rd_jc";

const std::string TRANSPORT_PREFIX = "transport_";

const std::string TRANSPORT_METRO_STATION = "transport_metro_station";
const std::string TRANSPORT_METRO_EXIT = "transport_metro_exit";
const std::string TRANSPORT_METRO_LINE = "transport_metro_line";

const std::string TRANSPORT_BUS_ROUTE = "transport_bus_route";
const std::string TRANSPORT_TRAM_ROUTE = "transport_tram_route";
const std::string TRANSPORT_WATERWAY_ROUTE = "transport_waterway_route";
const std::string TRANSPORT_OPERATOR = "transport_operator";
const std::string TRANSPORT_METRO_OPERATOR = "transport_metro_operator";
const std::string TRANSPORT_METRO_THREAD = "transport_metro_thread";
const std::string TRANSPORT_BUS_THREAD = "transport_bus_thread";
const std::string TRANSPORT_TRAM_THREAD = "transport_tram_thread";
const std::string TRANSPORT_WATERWAY_THREAD = "transport_waterway_thread";

const std::string TRANSPORT_TRAM_EL = "transport_tram_el";

const std::string TRANSPORT_AIRPORT = "transport_airport";
const std::string TRANSPORT_AIRPORT_TERMINAL = "transport_airport_terminal";
const std::string TRANSPORT_HELICOPTER = "transport_helicopter";

const std::string TRANSPORT_TERMINAL = "transport_terminal";
const std::string TRANSPORT_STOP = "transport_stop";

const std::string TRANSPORT_RAILWAY_STATION = "transport_railway_station";

const std::string TRANSPORT_WATERWAY_STOP = "transpot_waterway_stop";

const std::string INDOOR_POI_PREFIX = "indoor_poi_";
const std::string INDOOR_AREA_PREFIX = "indoor_area";
const std::string POI_PREFIX = "poi_";
const std::string POI_ENTRANCE = "poi_entrance";

const std::string VEGETATION = "vegetation";

const std::string HYDRO = "hydro";
const std::string HYDRO_POINT = "hydro_point";

const std::string RELIEF = "relief";
const std::string RELIEF_POINT = "relief_point";

} // namespace cat

} // namespace maps::wiki::diffalert
