#include "rd_jc.h"
#include "magic_string.h"
#include "utils.h"
#include "../message_reporter.h"

#include <yandex/maps/wiki/diffalert/revision/diff_context.h>

namespace maps {
namespace wiki {
namespace diffalert {

void checkBoundJcChanges(const DiffContext& diff, MessageReporter& messages)
{
    if (!(diff.categoryId() == cat::RD_JC && diff.attrsChanged())) {
        return;
    }

    auto oldBoundJc = diff.oldObject() && diff.oldObject()->attr(attr::CAT_BOUND_JC).as<bool>();
    auto newBoundJc = diff.newObject() && diff.newObject()->attr(attr::CAT_BOUND_JC).as<bool>();

    if (!oldBoundJc && newBoundJc) {
        messages.report({1, 3}, "bound-jc-set");
    }
    if (oldBoundJc && !newBoundJc) {
        messages.report({1, 3}, "bound-jc-unset");
    }
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
