#pragma once

#include "magic_string.h"

#include <yandex/maps/wiki/diffalert/object.h>
#include <yandex/maps/wiki/diffalert/diff_context.h>
#include <yandex/maps/wiki/diffalert/snapshot.h>
#include <yandex/maps/wiki/common/rd/access_id.h>

#include <maps/libs/ymapsdf/include/ft.h>

#include <functional>
#include <string>
#include <unordered_set>

namespace maps::wiki::diffalert {

const std::unordered_set<int16_t> NMAPS_RESPONSIBILITY_FT_TYPES {
    1,
    105,
    110,
    111,
    112,
    113,
    114,
    164,
    166,
    167,
    168,
    169,
    172,
    175,
    182,
    183,
    184,
    191,
    202,
    220,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    232,
    233,
    253,
    254,
    1101,
    1102,
    1103,
    1104,
    1105,
    1106,
    1107,
    1108,
    1109,
    1110,
    1111,
    1112,
    1301,
    1303,
    1400,
    1601,
    1602,
    1701,
    1703,
    1704,
    1705,
    1706,
    1804,
    1805,
    1807,
    1808,
    1901,
    1903
}; // NMAPS_RESPONSIBILITY_FT_TYPES

const std::unordered_set<int16_t> SPRAV_RESPONSIBILITY_FT_TYPES {
    103,
    165,
    173,
    176,
    177,
    178,
    179,
    180,
    181,
    185,
    1000,
    1001,
    1002,
    1004,
    1302,
    1304,
    1305,
    1306,
    1307,
    1308,
    1309,
    1310,
    1311,
    1312,
    1313,
    1314,
    1315,
    1316,
    1317,
    1318,
    1319,
    1320,
    1401,
    1402,
    1403,
    1404,
    1405,
    1406,
    1407,
    1408,
    1409,
    1410,
    1501,
    1502,
    1503,
    1504,
    1505,
    1506,
    1507,
    1600,
    1603,
    1604,
    1605,
    1606,
    1607,
    1608,
    1609,
    1610,
    1611,
    1612,
    1613,
    1614,
    1615,
    1616,
    1702,
    1801,
    1802,
    1803,
    1806
}; // SPRAV_RESPONSIBILITY_FT_TYPES

class Object;
struct Priority;
struct MessageReporter;

enum class CalcSortPriority { Yes, No };

bool namesCreated(const DiffContext&);
bool namesDeleted(const DiffContext&);
bool namesChanged(const DiffContext&);
bool officialNamesCreated(const DiffContext& diff);
bool officialNamesDeleted(const DiffContext& diff);
bool officialNamesChanged(const DiffContext& diff);

template<typename Predicate>
bool isAny(const DiffContext& d, Predicate predicate)
{
    if (d.newObject() && predicate(*d.newObject())) {
        return true;
    }
    if (d.oldObject() && predicate(*d.oldObject())) {
        return true;
    }
    return false;
}

double mercatorDistanceRatio(double mercatorY);
double mercatorDistanceRatio(const Envelope& envelope);
double mercatorDistanceRatio(const Geom& geom);

using FtType = ymapsdf::ft::Type;

FtType getFtType(const Object& obj);

TIds join(TIds lhs, const TIds& rhs);

size_t utf8length(const std::string& utf8string);

typedef common::AccessId AccessId;

AccessId getAccessId(const Object& object);

const int DISP_CLASS_IGNORED = 10;

int getDispClass(const Object& object);

bool isUnderConstruction(const Object& object);

enum class SnapshotTime { Old, New };

struct ContourObjectArea {
    double exterior;
    double interior;
};

ContourObjectArea contourObjectArea(const DiffContext&, SnapshotTime);

double symDiffArea(const DiffContext&);

bool hasRelationWithRole(const Relations& relations, const std::string& role);

enum class LevelKind {
    Country = 1,
    Province = 2,
    Area = 3,
    Locality = 4,
    District = 5,
    Other = 6,
    Block = 7,
};

inline LevelKind getLevelKind(const Object& object) {
    return static_cast<LevelKind>(object.attr(attr::LEVEL_KIND).as<int>());
}

inline int operator-(LevelKind lhs, LevelKind rhs) {
    return static_cast<int>(lhs) - static_cast<int>(rhs);
}

TIds slaveRelativesIds(Object& object, const std::set<std::string>& roles);

double elementsLength(Snapshot& snapshot, const TIds& elementsIds);

bool isPoi(const std::string& categoryId);
bool isIndoor(const std::string& categoryId);

/* Returns True if it is POI from NMaps area of responsibility or
 * from Altay's one, but which we want to watch before publication
 * List of corresponding ft_type_id's is located here:
 * https://st.yandex-team.ru/NMAPS-9798#5cf7bbb765bae4001ec395ac
 */
bool isNmapsPoi(const Object& poi);

bool isMajorPoi(const Object& poi);

bool isGeoproductPoi(const Object& poi);
bool isGeoproductPoi(const DiffContext& context);

enum class RunMode {
    LongTask,
    Moderation
};

std::string makePoiMessage(const std::string& baseMessage, const DiffContext& context, RunMode runMode);

enum class PoiImportance {
    None,
    ImportantDispClass7,
    ImportantDispClass6,
    OtherDispClass5,
    ImportantDispClass5,
};

PoiImportance poiImportance(const Object& poi);
Priority poiMessagePriority(PoiImportance importance);

enum class TeamResponsibilityGroup
{
    Nmaps,
    Sprav,
    None
};

TeamResponsibilityGroup teamResponsibilityGroup(const Object& object);
TeamResponsibilityGroup teamResponsibilityGroup(const DiffContext& context);
Priority prioByRespGroup(const Priority& priority, TeamResponsibilityGroup group);
Priority prioByRespGroup(const Priority& priority, const DiffContext& context);

} // namespace maps::wiki::diffalert
