#pragma once

#include <yandex/maps/wiki/diffalert/object.h>
#include <maps/libs/introspection/include/comparison.h>

#include <cstdint>
#include <set>
#include <string>
#include <tuple>

namespace maps {
namespace wiki {
namespace diffalert {

namespace message {
const std::string POI_WITH_PRECISE_LOCATION_DISPLACED = "poi-with-precise-location-displaced";
const std::string POI_WITH_PRECISE_LOCATION_OFFICIAL_NAME_CHANGED = "poi-with-precise-location-official-name-changed";
const std::string POI_WITH_PRECISE_LOCATION_BUSINESS_ID_CHANGED = "poi-with-precise-location-business-id-changed";
const std::string POI_WITH_PRECISE_LOCATION_RUBRIC_ID_CHANGED = "poi-with-precise-location-business-rubric-id-changed";
}

struct Priority
{
    uint32_t major;
    uint32_t minor;
    double sort;

    Priority(uint32_t major_, uint32_t minor_, double sort = 0.0)
        : sort(sort)
    {
        major = major_;
        minor = minor_;
    }
};

class Message
{
public:
    enum class Scope { WholeObject, GeomDiff };

    Message(
        TId objectId,
        Priority priority,
        std::string description,
        Scope scope)
        : objectId_(objectId)
        , priority_(priority)
        , description_(std::move(description))
        , scope_(scope)
    { }

    TId objectId() const { return objectId_; };
    Priority priority() const { return priority_; };
    const std::string& description() const { return description_; };
    Scope scope() const { return scope_; };

private:
    TId objectId_;
    Priority priority_;
    std::string description_;
    Scope scope_;
};

inline auto introspect(const Priority& p)
{
    return std::tie(p.major, p.minor, p.sort);
}

inline auto introspect(const Message& m)
{
    return std::make_tuple(m.objectId(), m.priority(), m.description(), m.scope());
}

using introspection::operator==;
using introspection::operator<;
using introspection::operator!=;

} // namespace diffalert
} // namespace wiki
} // namespace maps
