#pragma once

#include <yandex/maps/wiki/common/attr_value.h>
#include <yandex/maps/wiki/diffalert/common.h>

#include <maps/libs/introspection/include/comparison.h>

#include <cstdint>
#include <set>
#include <string>

namespace maps {
namespace wiki {
namespace diffalert {

struct Relation
{
    TId masterId;
    TId slaveId;
    std::string role;
    size_t seqNum; // zero if not present
};

inline auto introspect(const Relation& r)
{
    return std::tie(r.masterId, r.slaveId, r.role, r.seqNum);
}

using introspection::operator==;
using introspection::operator<;
using introspection::operator!=;

typedef std::set<Relation> Relations;

using AttrValue = common::AttrValue;

class Object
{
public:
    virtual ~Object() {};

    virtual TId id() const = 0;
    virtual const std::string& categoryId() const = 0;

    virtual AttrValue attr(const std::string& name) const = 0;

    virtual const Geom& geom() const = 0;

    virtual Relations loadMasterRelations() = 0;
    virtual Relations loadSlaveRelations() = 0;

    virtual bool isFaceElement() const = 0;
    virtual bool isFaceJunction() const = 0;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
