#pragma once

#include <yandex/maps/wiki/diffalert/diff_context.h>
#include <maps/libs/common/include/pimpl_utils.h>

namespace maps {
namespace wiki {
namespace diffalert {

class AoiDiffContext : public DiffContext
{
public:
    virtual TId objectId() const;
    virtual const std::string& categoryId() const;

    virtual OptionalObject oldObject() const;
    virtual OptionalObject newObject() const;

    // Not implemented yet
    virtual Snapshot& oldSnapshot() const;
    // Not implemented yet
    virtual Snapshot& newSnapshot() const;

    virtual bool categoryChanged() const;
    virtual bool attrsChanged() const;
    virtual bool geomChanged() const;

    virtual const Relations& relationsAdded() const;
    virtual const Relations& relationsDeleted() const;

    virtual const Relations& tableAttrsAdded() const;
    virtual const Relations& tableAttrsDeleted() const;

    MOVABLE_PIMPL_DECLARATIONS(AoiDiffContext)
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
