#pragma once

#include <yandex/maps/wiki/diffalert/common.h>
#include <yandex/maps/wiki/diffalert/revision/editor_config.h>
#include <yandex/maps/wiki/diffalert/revision/aoi_diff_context.h>

#include <yandex/maps/wiki/revision/snapshot.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <vector>

namespace maps {
namespace wiki {
namespace diffalert {

enum class SplitPolicy
{
    Check,
    DoNotCheck
};

class AoiDiffLoader
{
public:
    AoiDiffLoader(
            EditorConfig config,
            Geom aoi,
            const revision::Snapshot& fromSnapshot,
            const revision::Snapshot& toSnapshot,
            revision::DBID fromBranchId,
            revision::DBID toBranchId,
            pqxx::transaction_base& txn);

    const EditorConfig& config() const;

    // default: 1.0
    double defaultMinLinearObjectIntersectionRatio() const;
    void setDefaultMinLinearObjectIntersectionRatio(double ratio);

    double minLinearObjectIntersectionRatio(const std::string& categoryId) const;
    void setMinLinearObjectIntersectionRatio(const std::string& categoryId, double ratio);

    std::vector<AoiDiffContext> loadDiffContexts(
        const std::set<std::string>& categoryIds,
        SplitPolicy splitPolicy = SplitPolicy::Check) const;

    MOVABLE_PIMPL_DECLARATIONS(AoiDiffLoader)
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
