#pragma once

#include <maps/libs/common/include/enum_bitset.h>

#include <memory>

namespace maps {
namespace wiki {
namespace diffalert {

enum class UserType : unsigned
{
    Common, /**< Includes common users, experts, moderators, yandex-moderators */
    Outsourcer,
    Cartographer,
    EnumBitsetFlagsEnd
};

using UserTypeFlags = maps::common::EnumBitset<UserType>;

enum class ActionType : unsigned
{
    Import,
    GroupMove,
    GroupEditAttributes,
    GroupDelete,
    Other,
    EnumBitsetFlagsEnd
};

using ActionTypeFlags = maps::common::EnumBitset<ActionType>;

/**
 * Exclude criteria: exclude an object if all the commits match the exclude condition otherwise include
 * Include criteria: include an object if all the commits match the include condition otherwise exclude
 */
class CommitFilter
{
public:
    CommitFilter() = default;

    /**
     * @return true if there are conditions set to find objects to be excluded
     *  otherwise the entire stage can be skipped
     */
    operator bool() const {
        return excludeActionTypes_.any() || !includeUserTypes_.all();
    }

    void setExcludedActionTypes(ActionTypeFlags flags) { excludeActionTypes_ = flags; }
    ActionTypeFlags excludedActionTypes() const { return excludeActionTypes_; }

    void setIncludedUserTypes(UserTypeFlags flags) { includeUserTypes_ = flags; }
    UserTypeFlags includedUserTypes() const { return includeUserTypes_; }

private:
    ActionTypeFlags excludeActionTypes_ = {};
    UserTypeFlags includeUserTypes_ = {UserType::Common, UserType::Outsourcer, UserType::Cartographer};
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
