#pragma once

#include <yandex/maps/wiki/revision/snapshot.h>
#include <yandex/maps/wiki/diffalert/common.h>
#include <yandex/maps/wiki/diffalert/revision/diff_context.h>
#include <geos/geom/Envelope.h>

#include <map>
#include <set>

namespace maps {
namespace wiki {
namespace diffalert {

// Bounding boxes representing geometry diff of an object.
// .before: whole object bbox before the edits
// .after: whole object bbox after the edits
// .removed: bbox of the geometries removed by the edits
// .added: bbox of the geometries added by the edits
// The following relations must hold:
// .removed is inside .before
// .added is inside .after
// .before expanded by .added = .after expanded by .removed
struct DiffEnvelopes {
    Envelope before;
    Envelope added;
    Envelope removed;
    Envelope after;
};

DiffEnvelopes
calcObjectDiffEnvelopes(
        TId objectId,
        const std::map<TId, const LongtaskDiffContext*>& diffContextById,
        const revision::Snapshot& oldSnapshot);

} // namespace diffalert
} // namespace wiki
} // namespace maps
