#pragma once

#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/xml/include/xml.h>

#include <string>
#include <set>

namespace maps::wiki::diffalert {

class EditorConfig
{
public:
    explicit EditorConfig(const xml3::Doc& doc);
    explicit EditorConfig(const std::string& path);

    const std::set<std::string>& tableAttrRoles(const std::string& category) const;

    const std::set<std::string>& geomPartCategories(const std::string& category) const;
    const std::set<std::string>& geomPartRoles(const std::string& category) const;
    const std::set<std::string>& geomPartMasterRoles(const std::string& category) const;

    bool isFaceCategory(const std::string& category) const;
    bool isFaceElementCategory(const std::string& category) const;
    bool isFaceJunctionCategory(const std::string& category) const;

    COPYABLE_PIMPL_DECLARATIONS(EditorConfig)
};

} // namespace maps::wiki::diffalert
