#pragma once

#include <yandex/maps/wiki/diffalert/object.h>
#include <maps/libs/common/include/pimpl_utils.h>

namespace maps {
namespace wiki {
namespace diffalert {

class FullyLoadedObject : public Object
{
public:
    TId id() const override;
    const std::string& categoryId() const override;

    AttrValue attr(const std::string& name) const override;

    const Geom& geom() const override;

    Relations loadMasterRelations() override;
    Relations loadSlaveRelations() override;

    bool isFaceElement() const override;
    bool isFaceJunction() const override;

    MOVABLE_PIMPL_DECLARATIONS(FullyLoadedObject)
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
