#pragma once

#include <yandex/maps/wiki/diffalert/object.h>

#include <memory>

namespace maps {
namespace wiki {
namespace diffalert {

class LongtaskObject : public Object
{
public:
    class Impl;
    explicit LongtaskObject(Impl&& impl);

    LongtaskObject(LongtaskObject&&) noexcept;
    LongtaskObject& operator=(LongtaskObject&&) noexcept;
    virtual ~LongtaskObject();

    TId id() const override;
    const std::string& categoryId() const override;

    AttrValue attr(const std::string& name) const override;

    const Geom& geom() const override;

    Relations loadMasterRelations() override;
    Relations loadSlaveRelations() override;

    bool isFaceElement() const override;
    bool isFaceJunction() const override;

private:
    std::unique_ptr<Impl> impl_;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
