#pragma once

#include <yandex/maps/wiki/diffalert/snapshot.h>

#include <memory>

namespace maps {
namespace wiki {
namespace diffalert {

class GeomIndex;

class LongtaskSnapshot : public Snapshot
{
public:
    class Impl;
    explicit LongtaskSnapshot(Impl&& impl);

    LongtaskSnapshot(LongtaskSnapshot&&) noexcept;
    LongtaskSnapshot& operator=(LongtaskSnapshot&&) noexcept;
    virtual ~LongtaskSnapshot();

    virtual std::vector<Snapshot::ObjectPtr> objectsByIds(const TIds& ids);

    virtual std::vector<Snapshot::ObjectPtr> primitivesByEnvelope(
        const Envelope& envelope,
        GeometryType geomType,
        const std::vector<std::string>& categoryIds);

    const GeomIndex& bldWith3Dmodel() const;

private:
    std::unique_ptr<Impl> impl_;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
