#pragma once

#include <yandex/maps/wiki/diffalert/object.h>

#include <vector>
#include <memory>

namespace maps {
namespace wiki {
namespace diffalert {

enum class GeometryType
{
    All,
    Point,
    LineString,
    Polygon
};

class Snapshot
{
public:
    typedef std::unique_ptr<Object> ObjectPtr;

    virtual ~Snapshot() {}

    virtual std::vector<ObjectPtr> objectsByIds(const TIds& ids) = 0;

    // Returns objects intersecting with envelope by their
    // bounding boxes.
    // May provide inexact results for the sake of speed.
    virtual std::vector<ObjectPtr> primitivesByEnvelope(
        const Envelope& envelope,
        GeometryType geomType,
        const std::vector<std::string>& categoryIds) = 0;
};


} // namespace diffalert
} // namespace wiki
} // namespace maps
