#pragma once

#include <yandex/maps/wiki/diffalert/storage/stored_message.h>

#include <maps/libs/st/include/st.h>

#include <string>

namespace maps::wiki::diffalert {

class IssueCreator
{
public:
    explicit IssueCreator(std::string baseUrl);
    IssueCreator(std::string baseUrl, std::string oAuthToken);

    std::string getOrCreateIssue(
        pqxx::transaction_base& txn,
        const StoredMessage& message,
        TId branchId,
        const std::string& reporterLogin,
        const std::string& categoryGroup,
        const std::string& pageUrl);

private:
    std::string createIssue(
        const StoredMessage& message,
        TId branchId,
        const std::string& reporterLogin,
        const std::string& categoryGroup,
        const std::string& pageUrl);

    std::string findIssue(StoredMessageId messageId);

    st::Gateway stGateway_;
};

} // namespace maps::wiki::diffalert
