#pragma once

#include <yandex/maps/wiki/diffalert/storage/stored_message.h>

#include <boost/optional.hpp>
#include <cstdint>
#include <memory>
#include <vector>

namespace maps {
namespace wiki {
namespace diffalert {

struct StoredMessagesFilter
{
    StoredMessagesFilter() {}

    boost::optional<std::string> geomWkb;
    boost::optional<uint32_t> majorPriority;
    std::vector<std::string> categoryIds;
    boost::optional<std::string> description;
    boost::optional<uint32_t> regionPriority;
    boost::optional<bool> postponed;
    boost::optional<TUId> excludeInspectedBy;
};

enum class SortKind
{
    ByName,
    BySize
};

class ResultsViewer
{
public:
    ResultsViewer(TaskId taskId, pqxx::transaction_base& txn);

    TaskId taskId() const { return taskId_; };

    size_t messageCount(const StoredMessagesFilter& filter);

    MessageStatistics statistics(const StoredMessagesFilter& filter);

    std::vector<StoredMessageId> messageIds(const StoredMessagesFilter& filter);

    StoredMessages messages(
        const StoredMessagesFilter& filter,
        SortKind sortKind,
        size_t offset,
        size_t limit);

    std::optional<StoredMessage> message(StoredMessageId messageId);

private:
    std::string messagesQuery(
        const StoredMessagesFilter& filter,
        const std::string& columns) const;

    TaskId taskId_;
    pqxx::transaction_base& txn_;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
