#pragma once

#include <yandex/maps/wiki/diffalert/message.h>

#include <vector>

namespace maps {
namespace wiki {
namespace diffalert {

struct MessageReporter
{
    MessageReporter(TId objectId_)
        : objectId(objectId_)
    {
    }

    void report(
        Priority priority,
        const std::string& description,
        Message::Scope scope = Message::Scope::WholeObject)
    {
        messages.emplace(objectId, priority, description, scope);
    }

    const TId objectId;
    std::set<Message> messages;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
