#include "aoi_diff_context_impl.h"

namespace maps {
namespace wiki {
namespace diffalert {

MOVABLE_PIMPL_DEFINITIONS(AoiDiffContext)

TId AoiDiffContext::objectId() const { return impl_->anyObject().id(); }

const std::string& AoiDiffContext::categoryId() const { return impl_->anyObject().categoryId(); }

OptionalObject AoiDiffContext::oldObject() const { return OptionalObject(impl_->oldObject.get()); }

OptionalObject AoiDiffContext::newObject() const { return OptionalObject(impl_->newObject.get()); }

Snapshot& AoiDiffContext::oldSnapshot() const
{
    throw maps::RuntimeError() << "not implemented";
}

Snapshot& AoiDiffContext::newSnapshot() const
{
    throw maps::RuntimeError() << "not implemented";
}

bool AoiDiffContext::categoryChanged() const { return impl_->categoryChanged; }

bool AoiDiffContext::attrsChanged() const { return impl_->attrsChanged; }

bool AoiDiffContext::geomChanged() const { return impl_->geomChanged; }

const Relations& AoiDiffContext::relationsAdded() const { return impl_->relationsAdded; }

const Relations& AoiDiffContext::relationsDeleted() const { return impl_->relationsDeleted; }

const Relations& AoiDiffContext::tableAttrsAdded() const { return impl_->tableAttrsAdded; }

const Relations& AoiDiffContext::tableAttrsDeleted() const { return impl_->tableAttrsDeleted; }


} // namespace diffalert
} // namespace wiki
} // namespace maps
