#include "bld.h"
#include "../checks/utils.h"
#include "../checks/magic_string.h"

#include "../message_reporter.h"
#include "../geom_index.h"

#include <yandex/maps/wiki/diffalert/revision/snapshot.h>
#include <yandex/maps/wiki/diffalert/revision/diff_context.h>

#include <algorithm>
#include <string>


namespace maps {
namespace wiki {
namespace diffalert {

void checkBldCloseToModel3D(const LongtaskDiffContext& diff, MessageReporter& messages)
{
    if (!(diff.categoryId() == cat::BLD && diff.newObject() && diff.geomChanged())) {
        return;
    }

    const Geom& geom = diff.newObject()->geom();
    if (geom.isNull()) {
        return;
    }

    const double maxDistanceToModel3d = 100 / mercatorDistanceRatio(geom);
    Envelope envelope = *geom->getEnvelopeInternal();
    envelope.expandBy(maxDistanceToModel3d);

    const TIds bldIds = diff.newSnapshot().bldWith3Dmodel().objectIdsByEnvelope(envelope);
    for (const auto& bld: diff.newSnapshot().objectsByIds(bldIds)) {
        if (bld->id() != diff.objectId() && bld->geom().distance(geom) < maxDistanceToModel3d) {
            messages.report({3, 4}, "bld-close-to-model3d");
            return;
        }
    }
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
