#include "general.h"

#include "../checks/magic_string.h"
#include "../checks/utils.h"
#include "../message_reporter.h"

#include <yandex/maps/wiki/diffalert/revision/diff_context.h>

#include <algorithm>

namespace maps::wiki::diffalert {
namespace {
bool isBlocked(const Object& object) {
    return static_cast<bool>(
        object.attr(attr::SYS_BLOCKED)
    );
}
} // namespace

void checkBlockedObjectChangeLongTask(
    const LongtaskDiffContext& diff,
    MessageReporter& messages)
{
    if (diff.oldObject() && isBlocked(*diff.oldObject())) {
        messages.report({3, 0}, "blocked-object-modified");
    }
}

} // namespace maps::wiki::diffalert
