#pragma once
#include <yandex/maps/wiki/diffalert/revision/diff_context.h>
#include <yandex/maps/wiki/diffalert/revision/object.h>
#include <yandex/maps/wiki/diffalert/revision/snapshot.h>

#include <memory>

namespace maps {
namespace wiki {
namespace revision {

class ObjectRevision;

} // namespace revision
namespace diffalert {

class RevSnapshotFactory;
class EditorConfig;

struct LongtaskObjectDiff
{
    LongtaskObjectDiff(
        const revision::ObjectRevision* oldRevPtr,
        const RevSnapshotFactory& oldRevSnapshotFct,
        const revision::ObjectRevision* newRevPtr,
        const RevSnapshotFactory& newRevSnapshotFct,
        const EditorConfig& config);

    LongtaskObject& anyObject() const
    { return newObject ? *newObject : *oldObject; }

    std::unique_ptr<LongtaskObject> oldObject;
    std::unique_ptr<LongtaskObject> newObject;

    bool categoryChanged;
    bool attrsChanged;
    bool geomChanged;
};

struct LongtaskRelationsDiff
{
    LongtaskRelationsDiff() { }

    LongtaskRelationsDiff& operator+=(LongtaskRelationsDiff&&);

    Relations relationsAdded;
    Relations relationsDeleted;
    Relations tableAttrsAdded;
    Relations tableAttrsDeleted;
};

struct LongtaskSnapshotPair {
    LongtaskSnapshot oldSnapshot;
    LongtaskSnapshot newSnapshot;
};

class LongtaskDiffContext::Impl
{
public:
    Impl(
        LongtaskSnapshotPair&& snapshotPair,
        LongtaskObjectDiff&& objectDiff,
        LongtaskRelationsDiff&& relationsDiff);

    LongtaskSnapshotPair snapshotPair;
    LongtaskObjectDiff objectDiff;
    LongtaskRelationsDiff relationsDiff;
};


} // namespace diffalert
} // namespace wiki
} // namespace maps
