#include "fully_loaded_object_impl.h"
#include "helpers.h"

namespace maps {
namespace wiki {
namespace diffalert {

MOVABLE_PIMPL_DEFINITIONS(FullyLoadedObject)

TId FullyLoadedObject::id() const
{ return impl_->data.id; }

const std::string& FullyLoadedObject::categoryId() const
{ return impl_->data.categoryId; }

AttrValue FullyLoadedObject::attr(const std::string& name) const
{
    return getAttrValue(impl_->data.attrs, name, impl_->data.categoryId);
}

const Geom& FullyLoadedObject::geom() const
{
    return impl_->data.geom;
}

Relations FullyLoadedObject::loadMasterRelations()
{
    return impl_->data.masterRelations;
}

Relations FullyLoadedObject::loadSlaveRelations()
{
    auto result = impl_->data.slaveRelations;
    result.insert(impl_->data.tableAttrs.begin(), impl_->data.tableAttrs.end());
    return result;
}

bool FullyLoadedObject::isFaceElement() const
{
    return impl_->data.isFaceElement;
}

bool FullyLoadedObject::isFaceJunction() const
{
    return impl_->data.isFaceJunction;
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
