#pragma once

#include <yandex/maps/wiki/diffalert/revision/fully_loaded_object.h>
#include <yandex/maps/wiki/revision/common.h>

namespace maps {
namespace wiki {
namespace diffalert {

struct FullyLoadedObjectData
{
    revision::DBID id;
    std::string categoryId;
    revision::Attributes attrs;
    Geom geom;
    Relations masterRelations;
    Relations slaveRelations;
    Relations tableAttrs;

    bool isFaceElement;
    bool isFaceJunction;
};

class FullyLoadedObject::Impl
{
public:
    explicit Impl(FullyLoadedObjectData data) : data(std::move(data)) {}

    FullyLoadedObjectData data;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
