#pragma once

#include <yandex/maps/wiki/diffalert/common.h>

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>

#include <memory>
#include <vector>

namespace maps {
namespace wiki {
namespace diffalert {

struct EnvelopeWithObjectId {
    Envelope envelope;
    TId objectId;

    EnvelopeWithObjectId(const Envelope& envelope, TId objectId)
        : envelope(envelope)
        , objectId(objectId)
    {}
};

class GeomIndex  {

public:
    explicit GeomIndex(const std::vector<EnvelopeWithObjectId>& envelopeAndObjectIdPairs);

    TIds objectIdsByEnvelope(const Envelope& envelope) const;

private:
    std::vector<geolib3::BoundingBox>  boundingBoxes_;
    geolib3::StaticGeometrySearcher<geolib3::BoundingBox, TId> searcher_;
};


class RevSnapshotFactory;

typedef std::shared_ptr<GeomIndex> GeomIndexPtr;

GeomIndexPtr makeBldWithModel3dGeomIndex(RevSnapshotFactory factory);


} // namespace diffalert
} // namespace wiki
} // namespace maps
