#include "helpers.h"

#include <boost/algorithm/string.hpp>
namespace maps {
namespace wiki {
namespace diffalert {

void fixEnvelope(Envelope& envelope)
{
    constexpr double EXPAND_BY = 0.001; // mercator meters
    if (!envelope.isNull()) {
        envelope.expandBy(EXPAND_BY);
    }
}

bool
areAttributesEqual(
    const revision::Attributes& oldAttrs,
    const revision::Attributes& newAttrs,
    const std::string& oldCategory,
    const std::string& newCategory)
{
    if (oldAttrs.size() != newAttrs.size()) {
        return false;
    }
    if (oldCategory == newCategory) {
        return oldAttrs == newAttrs;
    }
    revision::Attributes oldAttrsFixed;
    for (const auto& oldAttr : oldAttrs) {
        const auto& oldAttrName = oldAttr.first;
        const auto& oldAttrValue = oldAttr.second;
        oldAttrsFixed.insert({
            boost::replace_all_copy(oldAttrName, oldCategory, newCategory),
            oldAttrValue
        });
    }
    return oldAttrsFixed == newAttrs;
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
