#pragma once

#include <yandex/maps/wiki/diffalert/common.h>
#include <yandex/maps/wiki/diffalert/object.h>
#include <yandex/maps/wiki/revision/common.h>

namespace maps {
namespace wiki {
namespace diffalert {

// expand envelope a little because polygon without interior
// (e.g. created from an envelope with zero area) does not
// reliably intersect with AOIs. See NMAPS-3675.
void fixEnvelope(Envelope&);

inline AttrValue getAttrValue(
        const revision::Attributes& attrs, const std::string& name, const std::string& categoryId)
{
    auto hasColon = (name.find(':') != std::string::npos);
    auto attrName = hasColon ? name : categoryId + ':' + name;
    auto it = attrs.find(attrName);
    return AttrValue(std::move(attrName), it != attrs.end() ? it->second : std::string());
}

bool
areAttributesEqual(
    const revision::Attributes& oldAttrs,
    const revision::Attributes& newAttrs,
    const std::string& oldCategory,
    const std::string& newCategory);

inline bool isLinear(const Geom& geom)
{
    return dynamic_cast<const geos::geom::LineString*>(geom.geosGeometryPtr()) != nullptr;
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
