#pragma once

#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace diffalert {

const std::string CATEGORY_ATTR_PREFIX = "cat:";

namespace cat {

const std::string MODEL3D = "cat:model3d";
const std::string BLD = "cat:bld";
const std::string BOUND_JC = "cat:bound_jc";

} // namespace cat

namespace rel {

const std::string ROLE = "rel:role";
const std::string SLAVE = "rel:slave";
const std::string SEQ_NUM = "rel:seq_num";

} // namespace rel

const std::string DEFAULT_SEQ_NUM = "0";

const std::vector<std::string> SYSTEM_OBJECT_CAT_SUFFIXES = {
    "_nm", "_dt" };
const std::vector<std::string> GEOM_PART_CAT_SUFFIXES = {
    "_el", "_fc", "_jc", "_cnt" };

const std::vector<std::string> GEOM_PART_ROLES = {
    "part", "controlled", "fc_part", "from", "ln_part", "metro_part",
    "placed_at", "to", "via", "center" };

const std::string ASSOCIATED_WITH_ROLE = "associated_with";

const std::string IS_INTERIOR_ATTR_SUFFIX = ":is_interior";

} // namespace diffalert
} // namespace wiki
} // namespace maps
