#pragma once
#include <yandex/maps/wiki/diffalert/revision/object.h>
#include "db_access.h"

#include <yandex/maps/wiki/revision/common.h>

namespace maps {
namespace wiki {
namespace revision {

class ObjectRevision;

} // namespace revision
namespace diffalert {

class EditorConfig;

class LongtaskObject::Impl
{
public:
    enum class TDSType
    {
        FaceJunction,
        FaceElement,
        Other
    };

    Impl(
        const revision::ObjectRevision& objRev,
        RevSnapshotFactory revSnapshotFct,
        const EditorConfig& config);

    Impl(
        TId id,
        revision::Attributes attributes,
        Geom geom,
        RevSnapshotFactory recSnapshotFct,
        const EditorConfig& config);

    TId id;
    std::string categoryId;
    revision::Attributes attributes;
    Geom geom;
    TDSType tdsType;
    RevSnapshotFactory revSnapshotFct;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
