#include <yandex/maps/wiki/diffalert/revision/diff_context.h>
#include <yandex/maps/wiki/diffalert/revision/runner.h>

#include "../run_utils.h"

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include "checks/ad.h"
#include "checks/bld.h"
#include "checks/general.h"
#include "checks/indoor.h"
#include "checks/parkings.h"
#include "checks/poi.h"
#include "checks/rd_el.h"
#include "checks/transport.h"


namespace maps {
namespace wiki {
namespace diffalert {

namespace {

typedef std::function<void(const LongtaskDiffContext&, MessageReporter&)> LongTaskCheck;

const std::vector<LongTaskCheck> LONGTASK_SPECIFIC_CHECKS {
    checkAdChangesLongtask,
    checkAdSignificantAreaChange,
    checkAdSubst,
    checkRdElUnderConstructionLongTask,
    checkBldCloseToModel3D,
    checkBlockedObjectChangeLongTask,
    checkPoiInAreaOfModel3D,
    checkImportantPoi,
    checkMajorFeaturesLongTask,
    checkTramRouteChange,
    checkTransportPointDispClassChange,
    checkTransportPointsAnyChange,
    checkImportantRdLongtask,
    checkParkingLotLinearAttrsChanged,
    checkParkingLotLinearCreated,
    checkParkingLotLinearDeleted,
    checkParkingLotLinearZoneChanged,
    checkParkingLotLinearGeometrySignificantlyChanged,
    checkParkingLotCreated,
    checkRdElPoorCondition,
    checkRdAssociationLongTask,
    checkIndoorCreatedOrDeleted,
    checkIndoorAttrsModified,
    checkIndoorGeometryModified,

    checkCategoryChangeLongTask,
    checkLocationChangeLongTask,
    checkMajorPoiLongTask,
    checkPoiAssignLongTask,
    checkPoiNamesLongTask,
    checkPointHydroRelief,
    checkNamedFeatures
};

const std::string CHECK_INTERNAL_ERROR = "check-internal-error";

} // namespace


std::set<Message> runLongTaskChecks(const LongtaskDiffContext& d)
{
    MessageReporter reporter(d.objectId());
    try {
        runCommonChecks(d, reporter);
        run(d, reporter, LONGTASK_SPECIFIC_CHECKS);
    } catch (pqxx::failure& ex) {
        throw RuntimeError()
            << "Catch '" << ex.what() << "', while check object " << d.objectId();
    } catch (pgpool3::Pgpool3Error& ex) {
        throw;
    } catch (const maps::Exception& ex) {
        reporter.report({0, 0}, CHECK_INTERNAL_ERROR);
        ERROR() << "Catch maps::exception, while check object " << d.objectId();
        ERROR() << ex;
    } catch (const std::exception& ex) {
        reporter.report({0, 0}, CHECK_INTERNAL_ERROR);
        ERROR() << "Catch '" << ex.what() << "', while check object " << d.objectId();
    }

    return std::move(reporter.messages);
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
