#pragma once

#include "db_access.h"
#include "geom_index.h"

#include <yandex/maps/wiki/diffalert/revision/snapshot.h>
#include <yandex/maps/wiki/diffalert/revision/editor_config.h>


namespace maps {
namespace wiki {
namespace diffalert {

class LongtaskSnapshot::Impl
{
public:
    Impl(
        RevSnapshotFactory revSnapshotFct,
        ViewTxnFactory viewTxnFct,
        const GeomIndexPtr& bldWith3Dmodel,
        const EditorConfig& config);

    std::vector<Snapshot::ObjectPtr> primitivesByEnvelopeFromRevision(
        Envelope envelope,
        GeometryType geomType,
        const std::vector<std::string>& categoryIds);

    std::vector<Snapshot::ObjectPtr> primitivesByEnvelopeFromView(
        Envelope envelope,
        GeometryType geomType,
        const std::vector<std::string>& categoryIds);

    RevSnapshotFactory& revSnapshotFct() { return revSnapshotFct_; }
    ViewTxnFactory& viewTxnFct() { return viewTxnFct_; }
    const GeomIndexPtr& bldWith3Dmodel() const { return bldWith3Dmodel_; }

    const EditorConfig& config() const { return config_; }

private:
    RevSnapshotFactory revSnapshotFct_;
    ViewTxnFactory viewTxnFct_;
    GeomIndexPtr bldWith3Dmodel_;
    const EditorConfig& config_;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
