#pragma once

#include "aoi_diff_context_impl.h"

#include <yandex/maps/wiki/revision/common.h>

#include <pqxx/pqxx>

namespace maps {
namespace wiki {
namespace diffalert {

using TObjectIds = std::set<revision::DBID>;
using TCommitIds = std::set<revision::DBID>;

/**
Search for the splits of linear objects.
Use it only from the single branch.
*/
class SplitFinder
{
public:
    SplitFinder(
        pqxx::transaction_base& txn,
        revision::DBID branchId,
        revision::DBID fromCommitId,
        revision::DBID toCommitId,
        std::map<revision::DBID, AoiDiffData>& diffs);

    void run();

private:
    void collectObjectIdsFromDiffs();

    void collectEditNotes();
    TObjectIds collectEditNotesForObjects(const TObjectIds& objectIds);

    void checkForSplit();

    bool checkCreatedBySplitObject(AoiDiffData& diff);
    bool checkModifiedBySplitObject(AoiDiffData& diff);

    pqxx::transaction_base& txn_;
    revision::DBID branchId_;
    revision::DBID fromCommitId_;
    revision::DBID toCommitId_;
    std::map<revision::DBID, AoiDiffData>& diffs_;

    TObjectIds oldObjectIds_;
    TObjectIds newObjectIds_;

    TObjectIds modifiedBySplitObjectIds_;
    std::map<revision::DBID, TObjectIds> objectIdToSourceCandidateIds_;

    TObjectIds alreadyLoadedObjectIds_;
    TCommitIds alreadyLoadedCommitIds_;
};

} // namespace diffalert
} // namespace wiki
} // namespace maps
