#include "run_utils.h"

namespace maps::wiki::diffalert {

namespace {

const std::vector<Check> COMMON_CHECKS {
    checkCapitalAd,
    checkAdHierarchyChange,
    checkAdRecognitionChange,
    checkAdDispClass,
    checkAdLevelKind,
    checkAdBigAreaCreated,
    checkAdPopulationChange,

    checkArrivalPointModified,
    checkEntranceFlatRanges,

    checkHighScaleRdType,
    checkKilometerRdType,

    checkHighFcAccessId,
    checkRdElAttrs,
    checkLoneHighFcRdEl,
    checkRdElNearBoundJcOrBlockedRd,

    checkBoundJcChanges,

    checkUrbanAndRoadnetArealChange,

    checkContourFeatureArea,

    checkForbiddenCond,
    checkCondTollModified,
    checkCondAnnotationModified,
    checkCondRdElMoved,
    checkCondRdJcMoved,

    checkCondDsCreated,
    checkCondDsDeleted,
    checkCondDsAttributesModified,
    checkCondDsGeometryModified,

    checkMajorTransport,
    checkTransportTypeChange,
    checkTransportAssignChange,
    checkMetroChange,
    checkAirfieldChange,
    checkTransportRailway,

    checkAddrNames,

    checkBldWithModel3D,
    checkBigBld,
    checkBldAttrs,
    checkBldWithImportantPoi,

    checkMasstransitOperatorCreatedOrDeleted,
    checkMasstransitNotOperatingChange,
    checkMasstransitRouteOfficialNameChange,
    checkMasstransitRouteSchedule,
    checkMasstransitRouteWithThreadsModified,
    checkMasstransitStopSignificantMove,
    checkMasstransitRouteThreadsCount,
    checkMasstransitOperatorRoutesCount,
    checkMasstransitTransportStopWaiypointFlagChange,
    checkMasstransitThreadCompositionChange,

    checkPoiWithPositionQuality,
};

} // namespace

void runCommonChecks(const DiffContext& d, MessageReporter& reporter)
{
    run(d, reporter, COMMON_CHECKS);
}

} // namespace maps::wiki::diffalert
