#pragma once
#include "message_reporter.h"

#include "checks/ad.h"
#include "checks/addr.h"
#include "checks/arrival_point.h"
#include "checks/bld.h"
#include "checks/cond_ds.h"
#include "checks/condition.h"
#include "checks/flat_range.h"
#include "checks/ft.h"
#include "checks/generic.h"
#include "checks/masstransit.h"
#include "checks/poi.h"
#include "checks/rd.h"
#include "checks/rd_el.h"
#include "checks/rd_jc.h"
#include "checks/transport.h"

#include <yandex/maps/wiki/diffalert/diff_context.h>
#include <yandex/maps/wiki/diffalert/revision/diff_context.h>
#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace diffalert {


typedef std::function<void(const DiffContext&, MessageReporter&)> Check;

void runCommonChecks(const DiffContext& d, MessageReporter& reporter);

template<typename TDiff, typename TCheck>
void run(const TDiff& d, MessageReporter& reporter, const std::vector<TCheck>& checks)
{
    for (const auto& check : checks) {
        check(d, reporter);
    }
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
